% ==========================================================================
%  LSEISTFTM.M xe = lseistftm(X,win_func,frame_advance,iter)
% 
%  Description: This function computes the least squares error estimate of
%               signal xe given a modified short-time Fourier transform
%               magnitude.  (Least Squares Error Inverse Short Time Fourier
%               (Transform Magnitude ==> LSEISTFTM).
% 
%  Input Arguments:
% 	Name: X
% 	Type: matrix (FFT-length x number of frames)
% 	Description: the modified STFT magnitude
% 
% 	Name: win_func
% 	Type: vector (window-length x 1)
% 	Description: the window used in the original STFT computation
% 
% 	Name: frame_advance
% 	Type: scalar
% 	Description: the frame advance in number of samples
% 
% 	Name: iter
% 	Type: scalar
% 	Description: number of iterations
% 
%  Output Arguments:
% 	Name: xe
% 	Type: vector 
% 	Description: the reconstructed time sequence from X
% 
%  References:
%  [1] T. F. Quatieri, "Discrete-Time Speech Signal Processing Principles 
%   and Practice," Prentice Hall, 2002.  pp. 342-343
% 
%  [2] D. W. Griffin and J. S. Lim, "Signal Estimation from Modified Short-
%   Time Fourier Transform," IEEE Transactions on Acoustics, Speech, and
%   Signal Processing, vol. ASSP-32, no. 2, Apr 1984, pp. 236-243.
% 
% --------------------------------------------------------------------------
%  Notes:
%  This is the LSE computation for a modified STFT *magnitude*, not for a
%  modified STFT as presented in both the references above.  Thus, it is an
%  iterative version of the modified STFT algorithm.
% 
%  The algorithm asymptotically approaches it's final answer; empirically, 
%  the majority of improvement (in the distance between X and Xe) is 
%  achieved in the first 5-10 iterations.
% 
%  This code was modified from the lseistft code from Phillip De Leon.
% 
% --------------------------------------------------------------------------
%  Author: Laura E. Boucheron
% 
%  Creation Date: 11 February 2008
% 
%  Copyright 2007, Board of Regents at New Mexico State University,
%  All Rights Reserved
% --------------------------------------------------------------------------
%  Revision History:
%  12 August 2008
%   Revised code to work for all window overlaps (frame advances).
%  2009-2011
%   Comments added.(Steven Sandoval)
%   Fixed location of window normalization (Steven Sandoval)
% ==========================================================================
%
